;;;  Dateiname: sitzbank.lsp  -  erstellt: Thomas Elbracht
;;;  4.2024  -  fr AC2023       mail: te@elbracht-web.de
;;;  Aufruf mit: sitzbank
;;;
;;;  Die Routine erstellt eine Sitzbank oder Eckbank fr den Einrichtungsplaner
;;
  (defun Te:sitzbankIni ()
  ; speichert die Variablen
  (if *error*				
    (setq *te:error* *error*)		
  )

  (setq cealt (getvar "CMDECHO")
        mealt (getvar "MENUECHO")
	osalt (getvar "OSMODE")
	ortalt (getvar "ORTHOMODE")
	layalt (getvar "CLAYER")
	coalt (getvar "CECOLOR")
	delalt (getvar "DELOBJ")
	)
  
  	(setvar "CMDECHO" 0)
	(setvar "MENUECHO" 0)
  	(setvar "OSMODE" 0)
        (setvar "ORTHOMODE" 0)
        (setvar "DELOBJ" 2)
    
  (defun *error* (sTxt)	
    (princ (strcat "\n" sTxt))

  (setvar "CMDECHO" cealt)
  (setvar "MENUECHO" mealt)
  (setvar "OSMODE" osalt) 
    
    (if	*te:error*
      (setq *error* *te:error*)	
      (setq *error* nil)
    )
    (princ)
  )
nil
)
(defun Te:sitzbankDlg ()
(setq next 4)
(setq	IMG1 "sitzbank(logo)"
	fil1 IMG1
  ) 
(if (not dcl_id) (setq dcl_id (load_dialog "sitzbank")))

  (while (> next 1)
  (new_dialog "Sitzbank" dcl_id)

	(setq brei (dimx_tile "DIA"))
    	(setq hoe (dimy_tile "DIA"))
    	(start_image "DIA")
    	(fill_image 0 0 brei hoe -2)
    	(slide_image 0 -20 550 350 (strcat "sitzbank(sitzbank"Dn"))"))
	(end_image)
 
    (start_image "IMG1") 
    (slide_image 180 -40 180 130 fil1)
    (end_image)

 (if (= DBank 0) (progn(set_tile "DBank0" "1")(set_tile "DBank1" "0")
   (mode_tile "DschraegBr" 1)(mode_tile "DkurzBr" 1)(mode_tile "DkurzBrFuAnza" 1)))
 (if (= DBank 1) (progn(set_tile "DBank0" "0")(set_tile "DBank1" "1")
   (mode_tile "DschraegBr" 0)(mode_tile "DkurzBr" 0)(mode_tile "DkurzBrFuAnza" 0)))
    
    (set_tile "DlangBr" (rtos langBr 2 0))
    (set_tile "DschraegBr" (rtos schraegBr 2 0))
    (set_tile "DkurzBr" (rtos kurzBr 2 0))
    (set_tile "DMD" (rtos MD 2 0))
    (set_tile "DSitzHoe" (rtos SitzHoe 2 0))
    (set_tile "DFusSockelH" (rtos FusSockelH 2 0))
    (set_tile "DFusSockelD" (rtos FusSockelD 2 0))
    (set_tile "DlangBrFuAnza" (rtos langBrFuAnza 2 0))
    (set_tile "DkurzBrFuAnza" (rtos kurzBrFuAnza 2 0))
    (set_tile "DFusSeitAbst" (rtos FusSeitAbst 2 0))
    (action_tile "DIA" "(DO_DIA)")  
    (action_tile "DBank0" "(DO_Bank0 $value)")
    (action_tile "DBank1" "(DO_Bank1 $value)")   
    (action_tile "DlangBr" "(setq langBr (atof $value))")
    (action_tile "DschraegBr" "(setq schraegBr (atof $value))")
    (action_tile "DkurzBr" "(setq kurzBr (atof $value))")
    (action_tile "DMD" "(setq MD (atof $value))")
    (action_tile "DSitzHoe" "(setq SitzHoe (atof $value))")
    (action_tile "DFusSockelH" "(setq FusSockelH (atof $value))")
    (action_tile "DFusSockelD" "(setq FusSockelD (atof $value))")
    (action_tile "DlangBrFuAnza" "(setq langBrFuAnza (atoi $value))")
    (action_tile "DkurzBrFuAnza" "(setq kurzBrFuAnza (atoi $value))")
    (action_tile "DFusSeitAbst" "(setq FusSeitAbst (atof $value))")
    (action_tile "FUSSfrag" "(done_dialog 5)")
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "cancel" "(done_dialog 0)")
(setq next (start_dialog))
    (if	(= next 5)(DO_FUSS) )
    (if (= next 1) 
  (Te:sitzbankZeich)
  (Te:sitzbankBack)
  )
    )
  (unload_dialog dcl_id)
)
(defun Te:sitzbankZeich ()
  (vl-load-com)
  (vl-cmdf "_.view" "S" "TE_VIEW")
  (vl-cmdf "_.UCS" "W")
  (vl-cmdf "_.PLAN" "W")
  (setvar "CMDECHO" 0)
  (command-s "LAYER" "_M" "Te_sitzbank" "_CO" "53" "Te_sitzbank" "")

  (setvar "osmode" 0)(setvar "DELOBJ" 2)
    (setq Wi (aib 180) Wio (aib 90.0) Wiu (aib 270.0) Wir 0.0)
(vl-cmdf "_.UCS" "")
(vl-cmdf "_.UCS" "X" 90.0)
(vl-cmdf "_.UCS" "Y" -90.0)
  
  (setq FsPu1 (polar EP Wir 10)
	FsPu2 (polar FsPu1 Wir 460)
	FsPu3 (polar FsPu2 (aib 100) (+ FusSockelH 10.0))
	FsPu4 (polar FsPu1 Wio FusSockelH)
	FsPu5 (polar FsPu4 Wir 460)
	FsPu6 (inters FsPu2 FsPu3 FsPu4 FsPu5))

  (setq Pu0 (list (+(car EP)85 Md)(+(cadr EP)(- SitzHoe Md))(caddr EP))
	Pu1 (polar Pu0 Wir 190)
	Pu2 (polar Pu1 (aib 5) 210)
	Pu3 (polar Pu2 (aib 95) Md)
	Pu4 (polar Pu0 Wio Md)
	Pu31 (polar Pu4 Wir 220)
	Pu41 (polar Pu3 (aib 185) 250)
	Pu5 (inters Pu4 Pu31 Pu41 Pu3)
	)

  (setq Po1 (polar Pu0 Wio (+ 170 Md))
	Po2 (polar Po1 (aib 108) 295)
	Po3 (polar Po2 (aib 198) Md)
	Po5 (polar Pu0 Wi Md)
	Po41 (polar Po5 Wio 250)	
	Po31 (polar Po3 (aib 288) 350)
	Po4 (inters Po3 Po31 Po41 Po5)
	)

 (setq FuPu0 (polar FsPu4 Wio 1000)
       FuPu1 (inters Po3 Po4 FsPu4 FuPu0)
       FuPu2 (polar Pu1 (aib 5) 180)
       FuPu3 (list (-(car FsPu6)5)(cadr FsPu6)(caddr EP))
       FuPu4 (polar FuPu3 (aib 100) 50.0)
       FuPu5 (list (-(car FuPu4)60)(+(cadr FuPu4) 75.0)(caddr EP))
       FuPu6 (polar FuPu4 Wio 150.0)
       )
(vl-cmdf "_PLINE" FsPu1 FsPu2 FsPu6 FsPu4 "s")(setq sockel (entlast))
(vl-cmdf "_PLINE" FsPu4 FuPu3 FuPu4 "K" "P" FuPu5 FuPu6 "LI" FuPu2 Pu1 Po5 Po4 FuPu1 "s")(setq fuss (entlast))
(vl-cmdf "_PLINE" Pu0 Pu1 Pu2 Pu3 Pu5 Pu4 "s")(setq sitz (entlast))
(vl-cmdf "_PLINE" Pu0 Po1 Po2 Po3 Po4 Po5 "s")(setq lehne (entlast))

(setq MovePu (list (car Po3)(cadr EP)(caddr EP)))
(setq schiebwert (car MovePu)
      sitieff (- (car Po3) (car Pu2))
      sitief (abs sitieff))

  (vl-cmdf "_MOVE" sitz lehne fuss sockel "" MovePu EP)
  (vl-cmdf "_.UCS" "")

(setq nPo3 (list (car EP)(cadr EP)(cadr Po3))
      nPu2 (list (car EP) sitieff (cadr Pu2))
      VorK1 (polar nPu2 Wir langBr)
      VorK2 (polar VorK1 (aib 315) schraegBr)
      VorK3 (polar VorK2 Wiu kurzBr)
      VorK4 (polar VorK1 (aib 315) (/ schraegBr 2.0))
      VorK5 (polar VorK2 Wiu (/ kurzBr 2.0))
      EPfus (polar EP Wir (/ Md 2.0))
      EPsoc (polar EP Wir (/ FusSockelD 2.0))
      EPFusSok (polar EP Wir (+ FusSeitAbst (/ Md 2.0)))
      EPMidSitz (polar EP Wir (/ langBr 2.0))
      EPMidSitzMir (polar EPMidSitz Wio 200)
      EPMidSitzMirSr (polar VorK4 (aib 45) 200)
      EPMidSitzMirKu (polar VorK5 Wir 200)
      )
  
  (vl-cmdf "EXTRUSION" fuss "" Md)(setq fusteil (entlast))
  (vl-cmdf "_MOVE" fusteil "" EP EPfus)
  (vl-cmdf "EXTRUSION" sockel "" FusSockelD)(setq socteil (entlast))
  (vl-cmdf "_MOVE" socteil "" EP EPsoc)
  (vl-cmdf "_UNION" fusteil socteil "")(setq fusteil (entlast))

(if (= DBank 0)
  (progn
    (vl-cmdf "_PLINE" nPu2 VorK1 "")(setq extrLi1 (entlast))
    (vl-cmdf "EXTRUSION" sitz lehne "" "P" extrLi1)(setq sitzle (entlast))

  (setq langBrFuAnza (- langBrFuAnza 2) a 1
        fusabstL (/ (- langBr (* FusSeitAbst 2) Md) (+ langBrFuAnza 1)))
	 
     (vl-cmdf "_MOVE" fusteil "" EP EPFusSok)
  (vl-cmdf "_MIRROR" fusteil "" EPMidSitz EPMidSitzMir "")(setq fusteil2 (entlast))
     (setq fusins (polar EPFusSok Wir fusabstL))	      
     (vl-cmdf "_COPY" fusteil "" EPFusSok fusins)

    (while (> langBrFuAnza a)
     (vl-cmdf "_COPY" (entlast) "" fusins (polar fusins Wir fusabstL))
      (setq a (+ a 1))
    )
   )
  (progn   ;(if (= DBank 1)
    (vl-cmdf "_PLINE" nPu2 VorK1  VorK2  VorK3 "")(setq extrLi1 (entlast))
    (vl-cmdf "EXTRUSION" sitz lehne "" "P" extrLi1)(setq sitzle (entlast))
  (setq langBrFuAnza (- langBrFuAnza 2) a 1
        fusabstL (/ (- langBr (* FusSeitAbst 2) Md) (+ langBrFuAnza 1)))
	 
     (vl-cmdf "_MOVE" fusteil "" EP EPFusSok)
  (vl-cmdf "_MIRROR" fusteil "" EPMidSitz EPMidSitzMir "")(setq fusteil2 (entlast))
     (setq fusins (polar EPFusSok Wir fusabstL))	      
     (vl-cmdf "_COPY" fusteil "" EPFusSok fusins)

    (while (> langBrFuAnza a)
     (vl-cmdf "_COPY" (entlast) "" fusins (polar fusins Wir fusabstL))
      (setq a (+ a 1))
    )
  (setq kurzBrFuAnza (- kurzBrFuAnza 2) b 0
        fusabstK (/ (- kurzBr (* FusSeitAbst 2) Md) (+ kurzBrFuAnza 1)))
    
  (vl-cmdf "_MIRROR" fusteil2 "" VorK4 EPMidSitzMirSr "")(setq fusteil3 (entlast))
  (vl-cmdf "_MIRROR" fusteil3 "" VorK5 EPMidSitzMirKu "")(setq fusteil4 (entlast))
    
    (while (> kurzBrFuAnza b)
     (vl-cmdf "_COPY" fusteil3 "" VorK3 (polar VorK3 Wiu fusabstK))
      (setq b (+ b 1))
    )
  )    
)

  (vl-cmdf "_.view" "H" "TE_VIEW")
  (vl-cmdf "_.zoom" "G" "_.zoom" "0.8x")
  (vl-cmdf "_.view" "L" "TE_VIEW")
)
(defun DO_DIA ()
(setq Dn (itoa (- (atoi Dn) 1)))
(if (= Dn "0") (setq Dn "2"))
  
	(setq brei (dimx_tile "DIA"))
    	(setq hoe (dimy_tile "DIA"))
    	(start_image "DIA")
    	(fill_image 0 0 brei hoe -2)
    	(slide_image 0 -20 550 350 (strcat "sitzbank(sitzbank"Dn"))"))
	(end_image)
)
(defun DO_Bank0 (in)
(setq Bank_VAL (atof in))
(if (= Bank_VAL 1)  (progn (setq DBank 0)
		     (set_tile "DBank0" "1")(set_tile "DBank1" "0")
   (mode_tile "DschraegBr" 1)(mode_tile "DkurzBr" 1)(mode_tile "DkurzBrFuAnza" 1))
  )
  (DO_DIA)
)
(defun DO_Bank1 (in)
(setq Bank_VAL (atof in))
(if (= Bank_VAL 1)(progn (setq DBank 1)
		     (set_tile "DBank0" "0")(set_tile "DBank1" "1")
   (mode_tile "DschraegBr" 0)(mode_tile "DkurzBr" 0)(mode_tile "DkurzBrFuAnza" 0))
  )
   (DO_DIA)
)
(DEFUN aib (w) (* pi (/ w 180.0)))
(defun Te:sitzbankBack ()
  (setvar "CMDECHO" cealt)
  (setvar "MENUECHO" mealt)
  (setvar "OSMODE"  osalt)
  (setvar "CLAYER"  layalt)
  (setvar "CECOLOR" coalt)
  (setvar "ORTHOMODE" ortalt)
  (setvar "DELOBJ" delalt)
)
(defun C:sitzbank ( / dcl_id cealt mealt osalt ortalt layalt coalt delalt DBank langBr schraegBr kurzBr
		   Md SitzHoe FusSockelH FusSockelD FusSeitAbst fusabst langBrFuAnza kurzBrFuAnza sitief
		   GesamtBrL GesamtBrK Dn EP fil1 IMG1 next brei hoe Wi Wio Wiu Wir FsPu1 FsPu2 FsPu3 FsPu4
		   FsPu5 FsPu6 Pu0 Pu1 Pu2 Pu3 Pu4 Pu31 Pu41 Pu5 Po1 Po2 Po3 Po5 Po41 Po31 Po4 FuPu0 FuPu1
		   FuPu2 FuPu3 FuPu4 FuPu5 FuPu6 sockel fuss sitz lehne MovePu schiebwert sitieff nPo3
		   nPo2 VorK1 VorK2 VorK3 VorK4 VorK5 EPfus EPsoc EPFusSok EPMidSitz EPMidSitzMir 
		   EPMidSitzMirSr EPMidSitzMirKu fusteil socteil extrLi1 sitzle fusabstL fusteil2 fusins a
		   fusabstK fusteil3 fusteil4 b Bank_VAL)		  

  (Te:sitzbankIni)
  
(setq DBank 0   ; 0 = gerade 1 = Ecke
      langBr 2000   ; sitzbankbreite lang
      schraegBr 120 ; schrge Breite
      kurzBr 1200   ; sitzbankbreite kurz
      Md 30.0       ; MaterialDicke
      SitzHoe 430   ; Sitzhhe
      FusSockelH 50 ; Fu Sockelhhe
      FusSockelD (+ Md 10.0) ; Sockeldicke
      FusSeitAbst 100.0  ; Fu Abst seitl
      fusabst 800.0      ; FuAbstand
      langBrFuAnza 3 ; Anzahl Futeile lang
      kurzBrFuAnza 2 ; Anzahl Futeile kurz
      sitief 518.893   ; Sitztiefe
      GesamtBrL (+ langBr (/ schraegBr 1.414214) sitief) ; Gesamtbreite lang
      GesamtBrK (+ kurzBr (/ schraegBr 1.414214) sitief) ; Gesamtbreite kurz
      Dn "1"	; Dianummer
)

  (setq EP '(0.0 0.0 0.0))
	(Te:sitzbankDlg)
	(Te:sitzbankBack)
  	(princ)
   )
  (princ "\n  Copyright (c) 2024 Thomas Elbracht ")
  (princ "\n  Starten Sie mit dem Befehl << sitzbank >>  ")
  
  (princ)
